﻿using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.CellularTopologyObjects
{
    /// <summary>
    /// Manages GPS records for cellular topology.
    /// </summary>
    partial class GpsRecordsManager
    {
        /// <summary>
        /// Structure representing car's location in time.
        /// </summary>
        public struct Record
        {
            /// <summary>
            /// Car's location.
            /// </summary>
            public Point Point;

            /// <summary>
            /// Car's normalized direction vector.
            /// </summary>
            public Vector DirectionNormalizedVector;

            /// <summary>
            /// Time of the record.
            /// </summary>
            public TimeSpan Time;

            /// <summary>
            /// Car's hash code.
            /// </summary>
            public int CarHashCode;
        }
    }
}
